<?php

    /**
    *
    * copyright (c) 2013-2020 Heliac Technologies
    * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
    *
    * linee guida per l'utilizzo del logo http://www.geecom.org/articolo.php?id=34&alias=linee-guida-per-l%27uso-del-logo-geecom
    */

    include "../include/costanti.php";
    include "../include/util.php";
    include "../gUtil/DbManager.php";
    include "../gUtil/GestoreFileCsv.php";
    include "../gUtil/GestoreUpload.php";
    include "../classi/GeneratoreUrl.php";
    
    session_start();
    if(!isset($_SESSION["geecomAdmin_email"]) || $_SESSION["geecomAdmin_ruolo"]!="super admin") {
        header("Location: index.php");
        exit();
    }
    
    //i dati del database sono definiti nel file costanti.php
    $geecomDb   = new DbManager($costantiDatabase);
    $nomeFile     = uniqid().".csv";
    $gestoreUpload = new GestoreUpload("file", array("text/plain"), 10000, "../file/csv", 0, "");
    $risultato = $gestoreUpload->salvaFile($nomeFile);
    
    $datiProdottoGeecom  = $geecomDb->leggiSingolaRiga("geec_prodotti",2);
    $impostazioni        = recuperaImpostazioni($geecomDb);
    $percorsoGeecomAdmin = GeneratoreUrl::creaUrlAreaAmministrativa($impostazioni,$datiProdottoGeecom);
    
    $gestoreCsv = new GestoreFileCsv("../file/csv/$nomeFile", ";",false);
    $tabellaImportazione = filter_input(INPUT_POST, "tabella", FILTER_SANITIZE_ADD_SLASHES);
    $gruppoAssociato     = filter_input(INPUT_POST, "gruppoAssociato", FILTER_SANITIZE_NUMBER_INT);
    $saltaIntestazione   = filter_input(INPUT_POST, "saltaIntestazione", FILTER_SANITIZE_ADD_SLASHES);
    $forzaId             = filter_input(INPUT_POST, "forzaId", FILTER_SANITIZE_ADD_SLASHES);
    
    $risColonne = $geecomDb->elencoColonneTabella($tabellaImportazione);
    $primaRiga     = $gestoreCsv->rigaSuccessiva();
    $colonneAttese = ($forzaId=="si") ? $risColonne->num_rows : $risColonne->num_rows -1;
    if(count($primaRiga) != $colonneAttese) {
        $numeroElementiRiga = count($primaRiga);
        header("Location: $percorsoGeecomAdmin/strumenti/importaEsporta/index.php?status=396&messaggio=Errore: il file contiene $numeroElementiRiga elementi, ne erano attesi $colonneAttese. . Se l'opzione forza id non è selezionata, ricordati di rimuovere la colonna con gli id dal tuo csv");
        exit();
    }

    if($saltaIntestazione=="si") {
        $gestoreCsv->setRigaCorrente(1);
    }
    else {
        $gestoreCsv->setRigaCorrente(0);
    }

    $queryImportazione = array();
    while(!$gestoreCsv->raggiuntaFineDelFile()) {
        $riga = $gestoreCsv->rigaSuccessiva();
        if($forzaId!="si") {
            $tmpQuery = "INSERT INTO $tabellaImportazione VALUES(NULL,";
        }
        else {
            $tmpQuery = "INSERT INTO $tabellaImportazione VALUES(";
        }
        
        foreach($riga as $elementoRiga) {
            $elementoCorrente = filter_var($elementoRiga,FILTER_SANITIZE_ADD_SLASHES);
            if($elementoCorrente!="NULL") {            
                $tmpQuery .= "'$elementoCorrente',";
            }
            else {
                $tmpQuery .= "$elementoCorrente,";
            }
        }
        $query = substr($tmpQuery, 0,strlen($tmpQuery) -1);
        $query .=")";

        $queryImportazione[count($queryImportazione)] = $query;
    }
    
    $numeroElementiImportati = count($queryImportazione);
    
    if($tabellaImportazione!="geec_utenti") {
        $geecomDb->eseguiInsiemeDiQuery($queryImportazione);
    }
    else if($gruppoAssociato==0) { // se si sta importando gli utenti e il gruppo associato non è stato selezionato si possono eseguire le query in blocco
        $geecomDb->eseguiInsiemeDiQuery($queryImportazione);        
    }
    else { // se è stato scelto un gruppo le query devono essere eseguite una alla volta perché per ogni utente va fatta una query subito dopo
        foreach($queryImportazione as $singolaQuery) {
            $idUtente = $geecomDb->eseguiQueryCreazione($singolaQuery);
            
            $queryAggiuntaGruppo = "INSERT INTO `geec_gruppiUtenti` (`idGruppoUtente`, `idUtente`, `idGruppo`) VALUES (NULL, '$idUtente', '$gruppoAssociato')";
            $geecomDb->eseguiQueryScrittura($queryAggiuntaGruppo);
        }
    }
    header("Location: $percorsoGeecomAdmin/strumenti/importaEsporta/index.php?status=200&numeroElementImportati=$numeroElementiImportati");
